#!/bin/bash
#
# Cleanup script for test dataset 7: Locations test
# Duplicate-finder testing methodology v3.4
#
# Removes all dup_location_test folders from various user locations
#

set -e

# ============================================================================
# SETTINGS
# ============================================================================

# Locations to remove
LOCATIONS=(
    "$HOME/Documents/dup_location_test"
    "$HOME/Desktop/dup_location_test"
    "$HOME/Downloads/dup_location_test"
    "$HOME/Movies/dup_location_test"
    "$HOME/Music/dup_location_test"
    "$HOME/Pictures/dup_location_test"
    "$HOME/Library/dup_location_test"
)

# File in the main test directory
MAIN_TEST_FILE="$HOME/DuplicateTest/test_location.mp4"

# ============================================================================
# MAIN SCRIPT
# ============================================================================

echo "============================================================"
echo "  Cleanup of test dataset 7: Locations test"
echo "============================================================"
echo ""

deleted_count=0
skipped_count=0

# Remove dup_location_test folders from all locations
for location in "${LOCATIONS[@]}"; do
    if [[ -d "$location" ]]; then
        echo -n "Deleting $location... "
        rm -rf "$location"
        echo "OK"
        ((deleted_count++))
    else
        echo "Skipped (does not exist): $location"
        ((skipped_count++))
    fi
done

# Remove the file from the main test directory
if [[ -f "$MAIN_TEST_FILE" ]]; then
    echo -n "Deleting $MAIN_TEST_FILE... "
    rm -f "$MAIN_TEST_FILE"
    echo "OK"
    ((deleted_count++))
else
    echo "Skipped (does not exist): $MAIN_TEST_FILE"
    ((skipped_count++))
fi

# ============================================================================
# SUMMARY
# ============================================================================

echo ""
echo "============================================================"
echo "  SUMMARY"
echo "============================================================"
echo ""
echo "Deleted locations: $deleted_count"
echo "Skipped (did not exist): $skipped_count"
echo ""
echo "Test dataset 7 has been removed."
echo ""

# =========================================================================
# ADDITIONAL CLEANUP (optional)
# =========================================================================

# If the ~/DuplicateTest folder exists, you can delete it entirely.
if [[ -d "$HOME/DuplicateTest" ]]; then
    remaining=$(ls -1 "$HOME/DuplicateTest" 2>/dev/null | wc -l | tr -d ' ')

    echo "Items currently in ~/DuplicateTest: $remaining"
    echo "This will delete ALL test datasets inside ~/DuplicateTest."

    # Ask for confirmation in the terminal (Y/N), default is No
    read -r -p "Delete the ~/DuplicateTest folder entirely? [y/N]: " answer
    case "$answer" in
        [Yy]|[Yy][Ee][Ss])
            rm -rf "$HOME/DuplicateTest"
            echo "OK: ~/DuplicateTest deleted."
            ;;
        *)
            echo "OK: leaving ~/DuplicateTest as is."
            ;;
    esac
fi

echo ""
echo "Done!"
